Rem
Rem $Header: xml_adm_cleanup.sql 17-jan-2007.15:12:18 chall Exp $
Rem
Rem xml_adm_cleanup.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      xml_adm_cleanup.sql - Removes the Messaging Gateway configuration.
Rem
Rem    DESCRIPTION
Rem      Script to remove Messaging Gateway configured objects used in
Rem      this sample.
Rem
Rem    NOTES
Rem      WARNING!! This script should be run when the Messaging Gateway 
Rem      agent is running. If the agent is not running, the propagation 
Rem      jobs will not be fully removed until the agent is restarted.
Rem
Rem      The order of removing MGW objects is important. A link cannot be 
Rem      removed until all associated foreign queues have been unregistered.
Rem      A foreign queue cannot be unregistered when propagation jobs, 
Rem      subscribers or schedules reference it.
Rem

connect mgwadm/mgwadm

Rem Remove the propagation jobs.
execute dbms_mgwadm.remove_job('job_xml_out');
execute dbms_mgwadm.remove_job('job_xml_in');

Rem Unregister the WebSphere MQ queue.
execute dbms_mgwadm.unregister_foreign_queue('destq','mqlink');

Rem Finally, remove the link.
execute dbms_mgwadm.remove_msgsystem_link('mqlink');
